import greenfoot.*;
import java.awt.Color;
import java.awt.Font;  

/** 
 * @author Vasilis Bilbilis 
 * @version 1.0 Version
 */

public class StartScreen extends World
{
    GreenfootImage startscr = new GreenfootImage("blue_space.png");
    public static final float fontSize = 38.0f;
    private String title = "Welcome to EduTrip!";
    private String playButtonMsg = "Play now";
    private String helpButtonMsg = "Instructions";
    
    public StartScreen()
    {    
        super(900,600,1);
        setBackground(startscr);
        Font font = startscr.getFont();
        font = font.deriveFont(fontSize);
        startscr.setFont(font);
        startscr.setColor(Color.WHITE);
        startscr.drawString(title, 280, 180);
        startscr.drawString(playButtonMsg, 385, 295);
        startscr.drawString(helpButtonMsg, 385, 365);
        addObject(new PlayButton(), 350, 280);
        addObject(new HelpButton(), 350, 350);

        prepare();
    }

    public void started()
    {
        Greenfoot.setWorld(this);
    }

    /**
     * Prepare the world for the start of the program. That is: create the initial
     * objects and add them to the world.
     */
    private void prepare()
    {
    }
}
