import greenfoot.*;  // (World, Actor, GreenfootImage, and Greenfoot)
import java.awt.Color;
import javax.swing.*;
import java.util.Random;
import java.util.List;

/** 
 * @author Vasilis Bilbilis 
 * @version 1.0 Version
 */

public class Space extends World
{
    private int startMeteors = 5;
    Spaceship spaceship = new Spaceship();
    private boolean programIsRunning = true;
    Counter scoreCounter = new Counter("Your Score: ", "Lives left: ");
    private boolean gameJustStarted = true;
    private int gameLevel;
    private boolean level1Passed = false;
    private boolean gameStart = false;
    private GamePlayInfo gameInfo;
    /** If count reaches a value it stops the program execution, to avoid infinite loop */
    private int count = 0;
    private GreenfootImage imageLevel1 = new GreenfootImage("SpaceHarder.jpg");
    private GreenfootImage imageLevel2 = new GreenfootImage("space.jpg");
    private GreenfootImage imageLevel3 = new GreenfootImage("blue_space.png");
    private QuestionBoard questionBoard = new QuestionBoard();
    private int value;
    private String keyPressed;
    private String rightAnswer;
    private boolean firstQuestion = true;
    private Random rand = new Random();
    private int questionCounter;
    private int rightAnswersCounter;
    
            
    public Space() 
    {
        super(900, 600, 1);
        setBackground(imageLevel1);
        gameLevel = 1;
        rightAnswersCounter = 0;
        prepare();        
    }
    
    public Space(int keepScore, int level) 
    {
        super(900, 600, 1);
        setBackground(imageLevel2);
        scoreCounter.add(keepScore);
        gameLevel = level;
        prepare();        
    }
    
    public Space(int keepScore, int level, int foo) 
    {
        super(900, 600, 1);
        setBackground(imageLevel3);
        scoreCounter.add(keepScore);
        gameLevel = level;
        prepare();        
    }
    
       
    public void prepare()
    {
        addObject(spaceship, 50 , 250);    
        addObject(scoreCounter, 450, 30);
        addMeteor(startMeteors);
        addObject(questionBoard, 450, 540);
        questionCounter = 1;
        startInfoMessage();        
    }
    
    public void act()
    {    
       while(!"enter".equals(Greenfoot.getKey()) && gameStart == false)
       {
           count++;
           Greenfoot.delay(1);
           if(count == 10000) 
           {
               Greenfoot.stop();
               break;
           }
       }
       gameStart = true;
       
       if(programIsRunning)
       {
           checkMeteorOnSpace();
           checkNextLevel();
       }
       
       if(firstQuestion)
       {
           value = rand.nextInt(30); 
           questionBoard.updateQuestion(value);
           rightAnswer = questionBoard.getRightAnswer(value);
           firstQuestion = false;
       }
       else
       {
           checkKeyPressed();
       }
    }
    
    private void checkKeyPressed()
    {
        if (Greenfoot.isKeyDown("a") && rightAnswer ==("a"))
        {
                scoreCounter.add(30);
                value = rand.nextInt(30); 
                questionBoard.updateQuestion(value);
                Greenfoot.delay(15);
                rightAnswer = questionBoard.getRightAnswer(value);
                destroyMeteors();
                questionCounter++;
                rightAnswersCounter++;
        }
        else if (Greenfoot.isKeyDown("b") && rightAnswer =="b")
        {
                scoreCounter.add(30);
                value = rand.nextInt(30); 
                questionBoard.updateQuestion(value);
                Greenfoot.delay(15);
                rightAnswer = questionBoard.getRightAnswer(value);
                destroyMeteors();
                questionCounter++;
                rightAnswersCounter++;
        }
        else if (Greenfoot.isKeyDown("c") && rightAnswer =="c")
        {
               scoreCounter.add(30);
               value = rand.nextInt(30); 
               questionBoard.updateQuestion(value);
               Greenfoot.delay(15);
               rightAnswer = questionBoard.getRightAnswer(value);
               destroyMeteors();
               questionCounter++;
               rightAnswersCounter++;
        }
        else if (Greenfoot.isKeyDown("d") && rightAnswer =="d")
        {
               scoreCounter.add(30);
               value = rand.nextInt(30); 
               questionBoard.updateQuestion(value);
               Greenfoot.delay(15);
               rightAnswer = questionBoard.getRightAnswer(value);
               destroyMeteors();
               questionCounter++;
               rightAnswersCounter++;
        }
        else if(Greenfoot.isKeyDown("a") && rightAnswer !=("a") || Greenfoot.isKeyDown("b") && rightAnswer !=("b") || Greenfoot.isKeyDown("c") && rightAnswer !=("c") || Greenfoot.isKeyDown("d") && rightAnswer !=("d"))
        {
               scoreCounter.add(-10);
               value = rand.nextInt(30); 
               questionBoard.updateQuestion(value);
               Greenfoot.delay(15);
               rightAnswer = questionBoard.getRightAnswer(value);
               questionCounter++;
        }
    }
        
    public void addMeteor(int startMeteors) 
    {
            for(int i = 0; i < startMeteors; i++) 
            {
                int x = (getWidth()+ 20);
                int y = getRandomNumber(25,450);
                addObject(new Meteor(scoreCounter), x, y);
            }
    }
    
    public void destroyMeteors()
    {
        for (Object obj : getObjects(Meteor.class))
        {
            Meteor m = (Meteor) obj;
            m.explode();
            removeObject(m);
        }
        
    }

    public void checkMeteorOnSpace()
    {
        int meteorsNum = getObjects(Meteor.class).size();
        if(meteorsNum == 0)
        {
            addMeteor(startMeteors);
        }
    }
          
    private void checkNextLevel()
    {       
            if (gameJustStarted)
            {
                gameJustStarted = false;
            }
            else if (gameLevel==1 && questionCounter == 11) 
            {
                gameLevel = 2;
                Greenfoot.playSound("Winner.mp3");
                Greenfoot.playSound("AudienceClap.mp3");
                Greenfoot.setWorld(new Space(scoreCounter.getScoreValue(), gameLevel));
            }
            else if (gameLevel==2 && questionCounter == 11) 
            {
                gameLevel = 3;
                Greenfoot.playSound("Winner.mp3");
                Greenfoot.playSound("AudienceClap.mp3");
                Greenfoot.setWorld(new Space(scoreCounter.getScoreValue(), gameLevel, 1));
            }
            else if (gameLevel==3 && questionCounter == 11)
            {
                Greenfoot.playSound("Winner.mp3");
                Greenfoot.playSound("AudienceClap.mp3");
                removeObjects(getObjects(Meteor.class));
                removeObjects(getObjects(Spaceship.class));
                programIsRunning = false;
                int score = scoreCounter.getScoreValue();
                Greenfoot.delay(10);
                String rightAnswers = "" + rightAnswersCounter;
                String questionAskedNum = "" + questionCounter;
                String text = "                Congratulations!" + "\n" + "You successfully completed the quiz!"+ "\n" +"You gave the right answer for "+rightAnswers+ " of "+ "\n"+ "                   "+ questionAskedNum +" questions";
                addObject(new ScoreBoard(score, text),  getWidth()/2, getHeight()/2);
                Greenfoot.stop();
            }
    }
              
    public void gameOver() 
    {
        removeObjects(getObjects(Meteor.class));
        removeObjects(getObjects(Spaceship.class));
        removeObjects(getObjects(QuestionBoard.class));
        programIsRunning = false;
        int score = scoreCounter.getScoreValue();
        Greenfoot.delay(10);
        addObject(new ScoreBoard(score), getWidth()/2, getHeight()/2);
        Greenfoot.playSound("gameLost.mp3");
    }
    
    public void startInfoMessage()
    {
        if(gameLevel == 1)
        {
            questionBoard.makeImage("Απάντησε σωστά στις ερωτήσεις πριν οι μετεορίτες φτάσουν στον προορισμό τους!", "Πάτησε το πλήκτρο ENTER για να ξεκινήσεις!");
        }
        else if(gameLevel == 2)
        {
            questionBoard.makeImage("Συγχαρητήρια, ολοκλήρωσες με επιτυχία το πρώτο επίπεδο!", "Πάτησε το πλήκτρο ENTER για να συνεχίσεις!");  
        }
        else
        {
            questionBoard.makeImage("Συγχαρητήρια, ολοκλήρωσες με επιτυχία και το δεύτερο επίπεδο!", "Πάτησε το πλήκτρο ENTER για να συνεχίσεις!");  
        }
        
    }
    
    public int getGameLevel()
    {
        return gameLevel;
    }
    
     public int getRandomNumber(int start,int end)
    {
       int normal = Greenfoot.getRandomNumber(end-start+1);
       return normal+start;
    }
}