import greenfoot.*;  // (World, Actor, GreenfootImage, and Greenfoot)
import java.awt.Color;
import java.awt.Font;
import java.util.Calendar;
import java.util.*;

/**
 * 
 * @Vasilis Bilbilis
 * @version 1.0
 */
public class QuestionBoard extends Actor
{
    public static final float FONT_SIZE = 14.0f;
    public static final int WIDTH = 900;
    public static final int HEIGHT = 120;
    //The list that will contain all the questions
    private String[][] QuestionsList = new String [30][6];
    private int count;
                  
    /**
     * Create a question board for the final result.
     */
    public QuestionBoard()
    {   
        count = 0;
        createQuestionArray();
    }
    
    /**
     * Make the question board image.
     *///
    public void makeImage(String message1, String message2)
    {
        GreenfootImage image = new GreenfootImage(WIDTH, HEIGHT);

        image.setColor(new Color(120, 120, 120, 255));
        image.fillRect(0, 0, WIDTH, HEIGHT);
        image.setColor(new Color(255, 255, 255, 255));
        image.fillRect(5, 5, WIDTH-10, HEIGHT-10);
        Font font = image.getFont();
        font = font.deriveFont(FONT_SIZE);
        image.setFont(font);
        image.setColor(Color.black);
        image.drawString(message1, 15, 25);
        image.drawString(message2, 15, 45);
        setImage(image);
    }
    
    public void createQuestion(String question, String answer1, String answer2, String answer3, String answer4)
    {
        GreenfootImage image = new GreenfootImage(WIDTH, HEIGHT);

        image.setColor(new Color(120, 120, 120, 255));
        image.fillRect(0, 0, WIDTH, HEIGHT);
        image.setColor(new Color(255, 255, 255, 255));
        image.fillRect(5, 5, WIDTH-10, HEIGHT-10);
        Font font = image.getFont();
        font = font.deriveFont(FONT_SIZE);
        image.setFont(font);
        image.setColor(Color.black);
        image.drawString(question, 15, 25);
        image.drawString(answer1, 15, 45);
        image.drawString(answer2, 15, 65);
        image.drawString(answer3, 15, 85);
        image.drawString(answer4, 15, 105);
        setImage(image);
    }
    
    public void updateQuestion(int value)
    {
        count++;
        createQuestion("Ερώτηση "+ count +": "+QuestionsList[value][0], QuestionsList[value][1], QuestionsList[value][2], QuestionsList[value][3], QuestionsList[value][4]);  
    }
    
    public String getRightAnswer(int value)
    {
        return QuestionsList[value][5];
    }
    
    private void createQuestionArray()
    {
        //Question 1
        QuestionsList[0][0] = "Τι είναι η κληρονομικότητα για τον αντικειμενοστραφή προγραμματισμό;";
        QuestionsList[0][1] = "a) Η ιδιότητα των κλάσεων να αναπαριστούν αφαιρετικά πολύπλοκες οντότητες";
        QuestionsList[0][2] = "b) η ιδιότητα που προσφέρουν οι κλάσεις να «κρύβουν» τα ιδιωτικά δεδομένα τους";
        QuestionsList[0][3] = "c) Η ιδιότητα των κλάσεων να επεκτείνονται σε νέες κλάσεις";
        QuestionsList[0][4] = "d) Όλα τα παραπάνω";
        QuestionsList[0][5] = "c";
        
        //Question 2
        QuestionsList[1][0] = "Τι ονομάζουμε ενθυλάκωση δεδομένων στον αντικειμενοστραφή προγραμματισμό;";
        QuestionsList[1][1] = "a) Η ιδιότητα των κλάσεων να αναπαριστούν αφαιρετικά πολύπλοκες οντότητες";
        QuestionsList[1][2] = "b) η ιδιότητα που προσφέρουν οι κλάσεις να «κρύβουν» τα ιδιωτικά δεδομένα τους";
        QuestionsList[1][3] = "c) Η ιδιότητα των κλάσεων να επεκτείνονται σε νέες κλάσεις";
        QuestionsList[1][4] = "d) Την κατάσταση κατά την οποία μία θυγατρική κλάση και η γονική της έχουν μία μέθοδο ομώνυμη και με τα ίδια ορίσματα";
        QuestionsList[1][5] = "b";
        
        //Question 3
        QuestionsList[2][0] = "Ποιος από τους παρακάτω τύπους χρησιμοποιείται για την δήλωση μεταβλητής μήκους ενός χαρακτήρα;";
        QuestionsList[2][1] = "a) Byte";
        QuestionsList[2][2] = "b) Short";
        QuestionsList[2][3] = "c) Long";
        QuestionsList[2][4] = "d) Char";
        QuestionsList[2][5] = "d";
        
        //Question 4
        QuestionsList[3][0] = "Ποιο από τα παρακάτω συμβολίζει τον τερματισμό γραμμής στην Java;";
        QuestionsList[3][1] = "a) }";
        QuestionsList[3][2] = "b) )";
        QuestionsList[3][3] = "c) ;";
        QuestionsList[3][4] = "d) :";
        QuestionsList[3][5] = "c";
        
         //Question 5
        QuestionsList[4][0] = "Ποια από τις παρακάτω λέξεις χρησιμοποιούμε για την δήλωση της κληρονομικότητας σε μια κλάση;";
        QuestionsList[4][1] = "a) Enlarge";
        QuestionsList[4][2] = "b) Extends";
        QuestionsList[4][3] = "c) Inherits";
        QuestionsList[4][4] = "d) Inheritance";
        QuestionsList[4][5] = "b";
        
        //Question 6
        QuestionsList[5][0] = "Αν Α=10 και Β=Α++ τότε το Β είναι ίσο με:";
        QuestionsList[5][1] = "a) 11";
        QuestionsList[5][2] = "b) 12";
        QuestionsList[5][3] = "c) 20";
        QuestionsList[5][4] = "d) 100";
        QuestionsList[5][5] = "a";
        
         //Question 7
        QuestionsList[6][0] = "Ποιος επιλογή από τις παρακάτω δεν αποτελεί τύπο δεδομένων στον προγραμματισμό;";
        QuestionsList[6][1] = "a) Long";
        QuestionsList[6][2] = "b) Byte";
        QuestionsList[6][3] = "c) Char";
        QuestionsList[6][4] = "d) String";
        QuestionsList[6][5] = "b";
        
         //Question 8
        QuestionsList[7][0] = "Ποιο σύμβολο από τα παρακάτω σημαίνει σχόλιο πολλαπλών γραμμών;";
        QuestionsList[7][1] = "a) //";
        QuestionsList[7][2] = "b) {}";
        QuestionsList[7][3] = "c) <>";
        QuestionsList[7][4] = "d) /**/";
        QuestionsList[7][5] = "d";
        
        //Question 9
        QuestionsList[8][0] = "Δηλώνει τις κοινές μεταβλητές και μεθόδους  για ένα σύνολο από αντικείμενα:";
        QuestionsList[8][1] = "a) Object";
        QuestionsList[8][2] = "b) Class";
        QuestionsList[8][3] = "c) Function";
        QuestionsList[8][4] = "d) Method";
        QuestionsList[8][5] = "b";
        
         //Question 10
        QuestionsList[9][0] = "To αρχείο που περιλαμβάνει όλα τα Java programming statements είναι γνωστό ως:";
        QuestionsList[9][1] = "a) Byte code";
        QuestionsList[9][2] = "b) Java file";
        QuestionsList[9][3] = "c) Source code";
        QuestionsList[9][4] = "d) Input file";
        QuestionsList[9][5] = "b";
       
        //Question 11
        QuestionsList[10][0] = "Ποιος από τους παρακάτω τελεστές μας δίνει το πηλίκο μιας διαίρεσης;";
        QuestionsList[10][1] = "a) /";
        QuestionsList[10][2] = "b) %";
        QuestionsList[10][3] = "c) &";
        QuestionsList[10][4] = "d) *";
        QuestionsList[10][5] = "a";
        
        //Question 12
        QuestionsList[11][0] = "Ποιο από ta παρακάτω θα εκτυπώσει σωστά το μήνυμα Hello World;";
        QuestionsList[11][1] = "a) System.out.println('Hello World');";
        QuestionsList[11][2] = "b) System.out.println('Hello World')";
        QuestionsList[11][3] = "c) System.out.printin('Hello World');";
        QuestionsList[11][4] = "d) System.out.print('Hello World');";
        QuestionsList[11][5] = "a";
        
         //Question 13
        QuestionsList[12][0] = "Ποιος τύπος από τους παρακάτω χρησιμοποιείται για την δήλωση αλφαριθμητικών;";
        QuestionsList[12][1] = "a) Strong";
        QuestionsList[12][2] = "b) int";
        QuestionsList[12][3] = "c) String";
        QuestionsList[12][4] = "d) float";
        QuestionsList[12][5] = "c";
        
         //Question 14
        QuestionsList[13][0] = "Ο κώδικας Java που είναι machine-independent λέγεται;";
        QuestionsList[13][1] = "a) source code";
        QuestionsList[13][2] = "b) byte code";
        QuestionsList[13][3] = "c) java code";
        QuestionsList[13][4] = "d) output code";
        QuestionsList[13][5] = "b";
        
         //Question 15
        QuestionsList[14][0] = "Ποια έκφραση από τις παρακάτω είναι σωστές;";
        QuestionsList[14][1] = "a) Η java είναι case-sensitive language";
        QuestionsList[14][2] = "b) Η java δεν είναι case-sensitive language";
        QuestionsList[14][3] = "c) Η java είναι γλώσσα που μπορεί να τρέξει μόνο σε περιβάλλον windows";
        QuestionsList[14][4] = "d) Η java δεν χρησιμοποιεί την ενθυλάκωση δεδομένων";
        QuestionsList[14][5] = "a";
        
        //Question 16
        QuestionsList[15][0] = "Ο πηγαίος κώδικας java έχει επέκταση;";
        QuestionsList[15][1] = "a) java";
        QuestionsList[15][2] = "b) doc";
        QuestionsList[15][3] = "c) javadoc";
        QuestionsList[15][4] = "d) class";
        QuestionsList[15][5] = "a";
        
        //Question 17
        QuestionsList[16][0] = "Σε τι τύπου δεδομένων μπορώ να αποθηκεύσω ένα όνομα;";
        QuestionsList[16][1] = "a) boolean";
        QuestionsList[16][2] = "b) string";
        QuestionsList[16][3] = "c) char";
        QuestionsList[16][4] = "d) float";
        QuestionsList[16][5] = "b";
        
        //Question 18
        QuestionsList[17][0] = "Ποια από τους παρακάτω τύπους μεταβλητών παίρνει τιμές true ή false;";
        QuestionsList[17][1] = "a) boolean";
        QuestionsList[17][2] = "b) string";
        QuestionsList[17][3] = "c) char";
        QuestionsList[17][4] = "d) float";
        QuestionsList[17][5] = "a";
        
        //Question 19
        QuestionsList[18][0] = "Τι σημαίνει ο όρος API;";
        QuestionsList[18][1] = "a) Application programming internet";
        QuestionsList[18][2] = "b) Application program interface";
        QuestionsList[18][3] = "c) Application programming interface";
        QuestionsList[18][4] = "d) Application programming interchange";
        QuestionsList[18][5] = "a";
        
        //Question 20
        QuestionsList[19][0] = "Τι σημαίνει ο όρος JVM;";
        QuestionsList[19][1] = "a) Java virtual machine";
        QuestionsList[19][2] = "b) Java virtual marking";
        QuestionsList[19][3] = "c) Java visual mockup";
        QuestionsList[19][4] = "d) Java visual machine";
        QuestionsList[19][5] = "a";
        
        //Question 21
        QuestionsList[20][0] = "Ποιο από τα παρακάτω αποτελεί τον πιο σημαντικό κανόνα για κάθε γλώσσα προγραμματισμού;";
        QuestionsList[20][1] = "a) Format";
        QuestionsList[20][2] = "b) Syntax";
        QuestionsList[20][3] = "c) Logic";
        QuestionsList[20][4] = "d) Object";
        QuestionsList[20][5] = "b";
        
        //Question 22
        QuestionsList[21][0] = "Ποιο είναι το μήκος μιας μεταβλητής τύπου float;";
        QuestionsList[21][1] = "a) 8 bits";
        QuestionsList[21][2] = "b) 16 bits";
        QuestionsList[21][3] = "c) 32 bits";
        QuestionsList[21][4] = "d) 64 bits";
        QuestionsList[21][5] = "c";
        
        //Question 23
        QuestionsList[22][0] = "Πότε χρησιμοποιείται η δήλωση void;";
        QuestionsList[22][1] = "a) Στην δήλωση μεταβλητής";
        QuestionsList[22][2] = "b) Στην δήλωση κλάσης";
        QuestionsList[22][3] = "c) Στην δήλωση μεθόδου";
        QuestionsList[22][4] = "d) Στην δήλωση παραμέτρου";
        QuestionsList[22][5] = "c";
        
        //Question 24
        QuestionsList[23][0] = "Πότε χρησιμοποιείται η δήλωση import;";
        QuestionsList[23][1] = "a) Στην δήλωση μεταβλητής";
        QuestionsList[23][2] = "b) Στην δήλωση κλάσης";
        QuestionsList[23][3] = "c) Στην δήλωση μεθόδου";
        QuestionsList[23][4] = "d) Στην εισαγωγή βιλβιοθήκης";
        QuestionsList[23][5] = "d";
        
        //Question 25
        QuestionsList[24][0] = "Τι ονομάζουμε αφαίρεση δεδομένων;";
        QuestionsList[24][1] = "a) Την ιδιότητα των κλάσεων να αναπαριστούν αφαιρετικά πολύπλοκες οντότητες";
        QuestionsList[24][2] = "b) Την ιδιότητα που προσφέρουν οι κλάσεις να «κρύβουν» τα ιδιωτικά δεδομένα τους από το υπόλοιπο πρόγραμμα";
        QuestionsList[24][3] = "c) Την ιδιότητα των κλάσεων να επεκτείνονται σε νέες κλάσεις";
        QuestionsList[24][4] = "d) Την κατάσταση κατά την οποία υπάρχουν, στην ίδια ή σε διαφορετικές κλάσεις, μέθοδοι με το ίδιο όνομα και πιθανώς διαφορετικά ορίσματα";
        QuestionsList[24][5] = "a";
        
        //Question 26
        QuestionsList[25][0] = "Αν προσθέσουμε ένα αριθμό int και έναν string θα πάρουμε έναν:";
        QuestionsList[25][1] = "a) int";
        QuestionsList[25][2] = "b) double";
        QuestionsList[25][3] = "c) string";
        QuestionsList[25][4] = "d) τίποτα από τα παραπάνω";
        QuestionsList[25][5] = "c";   
        
        //Question 27
        QuestionsList[26][0] = "Αν προσθέσουμε ένα αριθμό double και έναν int θα πάρουμε έναν:";
        QuestionsList[26][1] = "a) int";
        QuestionsList[26][2] = "b) double";
        QuestionsList[26][3] = "c) string";
        QuestionsList[26][4] = "d) τίποτα από τα παραπάνω";
        QuestionsList[26][5] = "b";  
        
        //Question 28
        QuestionsList[27][0] = "Αν προσθέσουμε ένα αριθμό double και τον κενό χαρακτήρα θα πάρουμε έναν:";
        QuestionsList[27][1] = "a) int";
        QuestionsList[27][2] = "b) double";
        QuestionsList[27][3] = "c) string";
        QuestionsList[27][4] = "d) τίποτα από τα παραπάνω";
        QuestionsList[27][5] = "b";  
        
        //Question 29
        QuestionsList[28][0] = "Κάθε αντικείμενο μια κλάσης δεν έχει πρόσβαση:";
        QuestionsList[28][1] = "a) στις μεθόδους της κλάσης του";
        QuestionsList[28][2] = "b) στις μεθόδους της υποκλάσης του";
        QuestionsList[28][3] = "c) στις μεταβλητές της κλάσης του";
        QuestionsList[28][4] = "d) τίποτα από τα παραπάνω";
        QuestionsList[28][5] = "b";  
        
        //Question 30
        QuestionsList[29][0] = "Η μέθοδος μιας κλάσης όταν επιστρέφουν την τιμή 0.25 πρέπει να έχει δηλωθεί ως:";
        QuestionsList[29][1] = "a) void";
        QuestionsList[29][2] = "b) int";
        QuestionsList[29][3] = "c) double";
        QuestionsList[29][4] = "d) τίποτα από τα παραπάνω";
        QuestionsList[29][5] = "c";
               
    }
}
