import greenfoot.*;  // (World, Actor, GreenfootImage, and Greenfoot)

/** 
 * @author Vasilis Bilbilis 
 * @version 1.0 Version
 */

public class Meteor extends SmoothMover
{
    private int size;
    private int count = 2;
    private Counter scoreCounter;
    private Vector speed;
    
    /** Number of fragments that meteor leaves when explodes*/
    private static final int NUM_FRAGMENTS = 40;
    
    public Meteor(Counter aCounter)
    {
        this(35);
        scoreCounter = scoreCounter;
        
    }
    
    public Meteor(int size)
    {
        super(new Vector(180,0.5));
        setSize(size);
    }
        
    public Meteor(Counter aCounter, double force)
    {
        this(50);
        addForce(new Vector(180,force));
        scoreCounter = aCounter;
        
    }
    
    public void explode()
    {
        placeMeteorFragments (getX(), getY(), NUM_FRAGMENTS);
    }
    
    private void placeMeteorFragments(int x, int y, int numFragments)
    {
        for (int i=0; i < numFragments; i++) {
            getWorld().addObject ( new MeteorBreaking(), x, y );
        }
    }
        
    public void act()
    {         
        
        Space space = (Space) getWorld();
        if(space.getGameLevel() == 1)
        {
            move();
            addForce(new Vector(180,0.002));
        }
        else if (space.getGameLevel() == 2)
        {
            move();
            addForce(new Vector(180,0.006));
        }
        else
        {
            move();
            addForce(new Vector(180,0.012));
        }
                
        makeFire();
        MeteorAtEdge();
    }

    /**
     * Set the size of this Meteor
     */
    public void setSize(int size) 
    {
        this.size = size;
        GreenfootImage image = getImage();
        image.scale(size, size);
    }
    
     private void setSpeed(Vector speed)
    {
        this.speed = speed;
    }
    
    public void MeteorAtEdge()
    {
        if(getX()==0) 
        {
            getWorld().removeObject(this);
        }
    }
        
    private void makeFire()
    {
        count--;
        if (count == 0) {
            getWorld().addObject ( new MeteorFire(), getX()+10, getY());
            count = 2;
        }
    }
  
}