import greenfoot.*;

/**
 * This class creates a Piece object.
 * 
 * @author Maria - Despoina Gkaintatzi
 * @version 24.04.2015
 */
public class Piece extends SmoothMover
{
    private static final Vector GRAVITY = new Vector(90, 1.5);
    private static final int FORCE = 10;
    
    /**
     * Constructor for objects of class Piece.
     */
    public Piece()
    {
        int direction = Greenfoot.getRandomNumber(360);
        int speed = Greenfoot.getRandomNumber(FORCE);
        increaseSpeed( new Vector(direction, speed));
        
        // random image size
        GreenfootImage img = getImage();
        int width = Greenfoot.getRandomNumber(30) + 1;
        int height = Greenfoot.getRandomNumber(30) + 1;
        img.scale (width, height);
        
        setRotation (Greenfoot.getRandomNumber(360));
    }
    
    /**
     * Act - do whatever the Debris wants to do. This method is called whenever
     * the 'Act' or 'Run' button gets pressed in the environment.
     */
    public void act() 
    {
        increaseSpeed(GRAVITY);
        moveOneStep();
    }    
}
