import greenfoot.*;
import java.awt.Color;
import java.awt.Font;
import java.util.Calendar;
import java.util.List;

/**
 * Class that represents MessageBoard object
 * 
 * @author Maria - Despoina Gkaintatzi
 * @version 12.06.2015
 */
public class MessageBoard extends Actor
{
    public static final float FONT_SIZE = 24.0f;
    public static final int WIDTH = 400;
    public static final int HEIGHT = 300;
    private String message;

    /**
     * Create a message board for displaying messages to the player.
     * 
     * @param message(String) the message to be displayed.
     */
    public MessageBoard(String title,String message)
    {
        makeImage(title,message);
    }

    /**
     * Make the message board image.
     * 
     * @param title(String) the title of the board.
     * @param prefix(String) what is being displayed before the score.
     */
    private void makeImage(String title,String message)
    {
        GreenfootImage image = new GreenfootImage(WIDTH, HEIGHT);

        image.setColor(new Color(63,236,16, 128));
        image.fillRect(0, 0, WIDTH, HEIGHT);
        image.setColor(new Color(0, 0, 0, 128));
        image.fillRect(5, 5, WIDTH-10, HEIGHT-10);
        Font font = image.getFont();
        font = font.deriveFont(FONT_SIZE);
        image.setFont(font);
        image.setColor(Color.WHITE);
        image.drawString(title, 60, 100);
        image.drawString(message, 60, 200);
        image.setTransparency(200);
        setImage(image);
    }   
}
