import greenfoot.*;
import java.awt.Color;
import java.awt.Font;
import java.util.List;
import java.util.ArrayList;

/**
 * This class creates a Letter object.
 * 
 * @author Maria - Despoina Gkaintatzi 
 * @version 12.06.2015
 */
public class Letter extends Actor
{
    private TextImage image;
    private String pattern1;
    private String pattern2;
    private String pattern3;
    private String pattern4;
    private String pattern5;
    private String pattern6;
    private String pattern7;
    private String pattern8;
    private String pattern9;
    private String pattern10;
    private String pattern11;
    private String pattern12;
    private String pattern13;
    private String pattern14;
    private String pattern15;
    private String pattern16;
    private String pattern17;
    private String pattern18;
    private String pattern19;
    private List<String> letters = new ArrayList<String>();
    public static int INDEX;
    public static int ITERATIONS = 1;

    /**
     * Constructor for objects of class Letter.
     * 
     * @param color(Color) the color of the letter
     */
    public Letter(Color color)
    {
        prepare();
        image = new TextImage(letterFromLevel(),new Font("Helvetica", Font.PLAIN, 50), color, null);
        setImage(image);
    }

    /**
     * Act - do whatever the Word wants to do. This method is called whenever
     * the 'Act' or 'Run' button gets pressed in the environment.
     */
    public void act() 
    {
        // Add your action code here.
    }  

    /**
     * Returns the image of the object Letter.
     * 
     * @return the image of the Letter object
     */
    public TextImage getTextImage()
    {
        return image;
    }

    /**
     * Initiates components that will be included in the constructor
     */
    private void prepare()
    {
        fillLists();
        pattern1 = "fdfdsfdsajkjkljkl;";
        pattern2 = "deedfrrfdeerreedreddeedfrrfdeerreedredfreefreedfred";
        pattern3 = "juujkiikjujkikjuujkiikjujkikjuujkiikjujkikjuujkiikjujkik";
        pattern4 = "juutjutkiitkitkitedriedfirfirefittedtiretireddriftedfruit;kite;";
        pattern5 = "ghghghghghghghghththththththththghtghtghtghtghtghtght";
        pattern6 = "judjudderjugjuggerjudgeighhighthighightfightrightfright";
        pattern7 = "weeweedwedwerewetwseetsweeterweedsweededseedseedsseeded";
        pattern8 = "loollookloothoottoolfoolfoolsdulldullerfullfullerhullhullshullotolltollsrollrollstoldfoldfolds";
        pattern9 = "jujjyyjjoytoyroytryfryjithitfitditwitlitlitterwetwetsjetjetsletletsletters";
        pattern10 = "fvffrfvffbffrfbfrevvetfivefiverfibfibberveryeveryjmjjujmjjnjjujnjjimhimtimrimhemthem";
        pattern11 = "jnjjujnjtinfindindinttinttententoftendendentoverovenmenmendmendedminemindmomentremember";
        pattern12 = "ououghroughtoughtroughenoughthoughthoughtthroughthoroughhousehousesmousemoundmounds";
        pattern13 = "roundroundssoundresoundedionlionmentionvisionvisionsiouiousconsciousenviousmissionmissions";
        pattern14 = "deddcddedcddecideddeckdeckedcheckcheesechestcheekcreekcreeksdicesliceslicedtwice";
        pattern15 = "typeslowlywithcorrectfingers;checkthecoloursinthefingercolumns;noticewhichlettershouldtypetheletterkeyyouneed;";
        pattern16 = "faffarfatfatterfarfarmerfanrantanjanlandhandbandpotportpitputpoppuppuppypurrtoproperomptraptramptrumpet";
        pattern17 = "figrigtigpiggotgripgreenringdingdongsongsangsingerarrangequitquitequitequillquiltqueerqueenquotequotedequateequationequalquackquaint";
        pattern18 = "zoozuluzigzagfaxtaxtextexitwewenttoseethezebrasandgiraffesatthezoomakesureyoutypethecorrecttextinyourdocument";
        pattern19 = "zoo.zulu,zigzag.fax,tax.text,exit.we,went.to,see.the,zebras.and,giraffes.at,the.zoo,make.sure,you.type,the.correct,text.in,your.";
    }

    /**
     * Fills letters list with letters from the keys of the middle row of the keyboard 
     */
    private void fillLists()
    {
        letters.add("a");
        letters.add("s");
        letters.add("d");
        letters.add("f");
        letters.add("j");
        letters.add("k");
        letters.add("l");
        letters.add(";");
    }

    /**
     * Selects the appropriate letter provider method according to the level.
     */
    private String letterFromLevel()
    {
        String letter = ""+((char)(Greenfoot.getRandomNumber(26)+97));
        if (Snail.LEVEL == 1)
        {
            letter = levelOneLetter();
        }
        if (Snail.LEVEL == 2)
        {
            letter = levelTwoLetter();
        }
        if (Snail.LEVEL == 3)
        {
            letter = levelThreeLetter();
        }
        if (Snail.LEVEL == 4)
        {
            letter = levelFourLetter();
        }
        if (Snail.LEVEL == 5)
        {
            letter = levelFiveLetter();
        }
        if (Snail.LEVEL == 6)
        {
            letter = ""+((char)(Greenfoot.getRandomNumber(26)+97));
        }
        return letter;
    }

    /**
     * Provides a certain pattern of letters for the first level of the game
     */
    private String levelOneLetter()
    {
        String letter = ""+((char)(Greenfoot.getRandomNumber(26)+97));
        // Level 1: asdf x 10 times && fdsa x 10 times
        if (ITERATIONS <= 160)
        {
            if(INDEX == 0)
            {
                letter = letters.get(0);
                if (ITERATIONS < 40)
                {
                    INDEX++;
                }
                else if (ITERATIONS == 40 || (ITERATIONS > 40 && ITERATIONS < 80))
                {
                    INDEX = 3;
                }
                else if (ITERATIONS == 80)
                {
                    INDEX = 4;
                }
            }
            else if(INDEX == 1)
            {
                letter = letters.get(1);
                INDEX = (ITERATIONS < 40) ? (INDEX + 1) : (INDEX - 1) ;
            }
            else if(INDEX == 2)
            {
                letter = letters.get(2);
                INDEX = (ITERATIONS < 40) ? (INDEX + 1) : (INDEX - 1) ;
            }
            else if(INDEX == 3)
            {
                letter = letters.get(3);
                if (ITERATIONS < 40)
                {
                    INDEX = 0;
                }
                else if (ITERATIONS > 40 && ITERATIONS < 80)
                {
                    INDEX--;
                }
                else if (ITERATIONS == 80)
                {
                    INDEX++;
                }
            }
            else if(INDEX == 4)
            {
                letter = letters.get(4);
                if (ITERATIONS < 120)
                {
                    INDEX++;
                }
                else if (ITERATIONS == 120 || (ITERATIONS > 120 && ITERATIONS < 160))
                {
                    INDEX = 7;
                }
                else if (ITERATIONS == 160)
                {
                    INDEX = 0;
                }
            }
            else if(INDEX == 5)
            {
                letter = letters.get(5);
                INDEX = (ITERATIONS < 120) ? (INDEX + 1) : (INDEX - 1) ;
            }
            else if(INDEX == 6)
            {
                letter = letters.get(6);
                INDEX = (ITERATIONS < 120) ? (INDEX + 1) : (INDEX - 1) ;
            }
            else if(INDEX == 7)
            {
                letter = letters.get(7);
                if (ITERATIONS < 120)
                {
                    INDEX = 4;
                }
                else if (ITERATIONS > 120 && ITERATIONS < 160)
                {
                    INDEX--;
                }
                else if (ITERATIONS == 160)
                {
                    INDEX = 0;
                }
            }

        }
        else if (ITERATIONS > 160 && ITERATIONS <= 178)
        {
            if (INDEX < pattern1.length())
            {
                letter = "" + pattern1.charAt(INDEX);
                INDEX++;
            }
            else
            {
                INDEX = 0;
                letter = "" + pattern1.charAt(INDEX);
            }

        }
        else if (ITERATIONS > 178 && ITERATIONS <= 229)
        {

            if (INDEX < pattern2.length())
            {
                letter = "" + pattern2.charAt(INDEX);
                INDEX++;
            }
            else
            {
                INDEX = 0;
                letter = "" + pattern2.charAt(INDEX);
            }
        }
        else if (ITERATIONS > 229 && ITERATIONS <= 285)
        {
            if (INDEX < pattern3.length())
            {
                letter = "" + pattern3.charAt(INDEX);
                INDEX++;
            }
            else
            {
                INDEX = 0;
                letter = "" + pattern3.charAt(INDEX);
            }
        }
        else if (ITERATIONS > 285 && ITERATIONS < 348)
        {
            if (INDEX < pattern4.length())
            {
                letter = "" + pattern4.charAt(INDEX);
                INDEX++;
            }
            else
            {
                INDEX = 0;
                letter = "" + pattern4.charAt(INDEX);
            }
        }
        else if (ITERATIONS > 348 && ITERATIONS < 401)
        {
            if (INDEX < pattern5.length())
            {
                letter = "" + pattern5.charAt(INDEX);
                INDEX++;
            }
            else
            {
                INDEX = 0;
                letter = "" + pattern5.charAt(INDEX);
            }
        }
        else if (ITERATIONS > 401 && ITERATIONS < 456)
        {
            if (INDEX < pattern6.length())
            {
                letter = "" + pattern6.charAt(INDEX);
                INDEX++;
            }
            else
            {
                INDEX = 0;
                letter = "" + pattern6.charAt(INDEX);
            }
        }

        ITERATIONS++;
        return letter;
    }

    /**
     * Provides a certain pattern of letters for the second level of the game
     */
    private String levelTwoLetter()
    {
        String letter = ""+((char)(Greenfoot.getRandomNumber(26)+97));
        if (ITERATIONS > 456 && ITERATIONS < 511)
        {
            if (INDEX < pattern7.length())
            {
                letter = "" + pattern7.charAt(INDEX);
                INDEX++;
            }
            else
            {
                INDEX = 0;
                letter = "" + pattern7.charAt(INDEX);
            }
        }
        else if (ITERATIONS > 511 && ITERATIONS < 605)
        {
            if (INDEX < pattern8.length())
            {
                letter = "" + pattern8.charAt(INDEX);
                INDEX++;
            }
            else
            {
                INDEX = 0;
                letter = "" + pattern8.charAt(INDEX);
            }
        }
        else if (ITERATIONS > 605 && ITERATIONS < 679)
        {
            if (INDEX < pattern9.length())
            {
                letter = "" + pattern9.charAt(INDEX);
                INDEX++;
            }
            else
            {
                INDEX = 0;
                letter = "" + pattern9.charAt(INDEX);
            }
        }
        ITERATIONS++;
        return letter;
    }

    /**
     * Provides a certain pattern of letters for the third level of the game
     */
    private String levelThreeLetter()
    {
        String letter = ""+((char)(Greenfoot.getRandomNumber(26)+97));
        if (ITERATIONS > 679 && ITERATIONS < 763)
        {
            if (INDEX < pattern10.length())
            {
                letter = "" + pattern10.charAt(INDEX);
                INDEX++;
            }
            else
            {
                INDEX = 0;
                letter = "" + pattern10.charAt(INDEX);
            }
        }
        else if (ITERATIONS > 763 && ITERATIONS < 850)
        {
            if (INDEX < pattern11.length())
            {
                letter = "" + pattern11.charAt(INDEX);
                INDEX++;
            }
            else
            {
                INDEX = 0;
                letter = "" + pattern11.charAt(INDEX);
            }
        }
        else if (ITERATIONS > 850 && ITERATIONS < 933)
        {
            if (INDEX < pattern12.length())
            {
                letter = "" + pattern12.charAt(INDEX);
                INDEX++;
            }
            else
            {
                INDEX = 0;
                letter = "" + pattern12.charAt(INDEX);
            }
        }
        else if (ITERATIONS > 933 && ITERATIONS < 1023)
        {
            if (INDEX < pattern13.length())
            {
                letter = "" + pattern13.charAt(INDEX);
                INDEX++;
            }
            else
            {
                INDEX = 0;
                letter = "" + pattern13.charAt(INDEX);
            }
        }
        ITERATIONS++;
        return letter;
    }

    /**
     * Provides a certain pattern of letters for the fourth level of the game
     */
    private  String levelFourLetter()
    {
        String letter = ""+((char)(Greenfoot.getRandomNumber(26)+97));
        if (ITERATIONS > 1023 && ITERATIONS < 1103)
        {
            if (INDEX < pattern14.length())
            {
                letter = "" + pattern14.charAt(INDEX);
                INDEX++;
            }
            else
            {
                INDEX = 0;
                letter = "" + pattern14.charAt(INDEX);
            }
        }
        else if (ITERATIONS > 1103 && ITERATIONS < 1213)
        {
            if (INDEX < pattern15.length())
            {
                letter = "" + pattern15.charAt(INDEX);
                INDEX++;
            }
            else
            {
                INDEX = 0;
                letter = "" + pattern15.charAt(INDEX);
            }
        }
        ITERATIONS++;
        return letter;
    }

    /**
     * Provides a certain pattern of letters for the fifth level of the game
     */
    private String levelFiveLetter()
    {
        String letter = ""+((char)(Greenfoot.getRandomNumber(26)+97));
        if (ITERATIONS > 1213 && ITERATIONS < 1317)
        {
            if (INDEX < pattern16.length())
            {
                letter = "" + pattern16.charAt(INDEX);
                INDEX++;
            }
            else
            {
                INDEX = 0;
                letter = "" + pattern16.charAt(INDEX);
            }
        }
        else if (ITERATIONS > 1317 && ITERATIONS < 1450)
        {
            if (INDEX < pattern17.length())
            {
                letter = "" + pattern17.charAt(INDEX);
                INDEX++;
            }
            else
            {
                INDEX = 0;
                letter = "" + pattern17.charAt(INDEX);
            }
        }
        else if (ITERATIONS > 1450 && ITERATIONS < 1560)
        {
            if (INDEX < pattern18.length())
            {
                letter = "" + pattern18.charAt(INDEX);
                INDEX++;
            }
            else
            {
                INDEX = 0;
                letter = "" + pattern18.charAt(INDEX);
            }
        }
        else if (ITERATIONS > 1560 && ITERATIONS < 1689)
        {
            if (INDEX < pattern19.length())
            {
                letter = "" + pattern19.charAt(INDEX);
                INDEX++;
            }
            else
            {
                INDEX = 0;
                letter = "" + pattern19.charAt(INDEX);
            }
        }
        ITERATIONS++;
        return letter;
    }
}
