import greenfoot.*;
import java.awt.Color;
import java.awt.Font;
import java.util.List;
import java.util.ArrayList;

/**
 * Class Desktop represents the world in which snail presents
 * all rules and instructions concerning the game.
 * 
 * @author Maria - Despoina Gkaintatzi 
 * @version 12.06.2015
 */
public class Desktop extends World
{
    private LeftHand leftHand;
    private RightHand rightHand;
    private Bubble firstBubble;
    private Boolean isShown;

    /**
     * Constructor for objects of class Desktop.
     * 
     */
    public Desktop(Snail snail)
    {    
        // Create a new world with 600x400 cells with a cell size of 1x1 pixels.
        super(1200, 800, 1); 
        prepare();
        addObject(snail, 50, 770);
        isShown = false;
    }

    /**
     * Act method for Desktop world.
     */
    public void act()
    {
        play();
        if (!isShown)
        {
            showNextBubble();
        }

    }
    
    /**
     * Initiates all components to be included in constructor.
     */
    private void prepare()
    {
        leftHand = new LeftHand(new GreenfootImage("leftHandPosition.png"));
        rightHand = new RightHand(new GreenfootImage("rightHandPosition.png"));
        addObject(new Keyboard(), 600, 250);
        addObject(leftHand, 400, 500);
        addObject(rightHand, 730, 500);
        String msg = "TO HELP YOU THROUGH THIS, I SHOULD GIVE\n" +
            "YOU SOME TIPS I LEARNED, WATCHING A SECRETARY\n" +
            "WHILE CROSSING HER WINDOW. EACH HAND IS\n" +
            "RESPONSIBLE FOR A CERTAIN HALF OF THE KEYBOARD\n" +
            "AND EACH FINGER HAS ITS CORRECT POSITION,\n" +
            "A KEY WHERE IT SHOULD ALWAYS RETURN, AFTER\n" +
            "TYPING ANY KEY.";
        firstBubble = new Bubble(50,new Vector(0,1),msg,new Font("Helvetica", Font.PLAIN, 18), 30);
        addObject (firstBubble, 100, 620);
    }

    /**
     * Starts game after clicking in the world.
     */
    private void play()
    {
        if(Greenfoot.mouseClicked(null))
        {
            Greenfoot.setWorld(new City(new Snail(50,new Vector(0,1))));
        }
        List<Snail> snails = this.getObjects(Snail.class);
        int xCoor = (int) snails.get(0).getExactX();

        if(xCoor >= 1100)
        {
            Greenfoot.setWorld(new City(new Snail(50,new Vector(0,1))));
        }
    }

    /**
     * Shows next bubble message approximately when snail has
     * reached the first half of the screen.
     */
    private void showNextBubble()
    {

        List<Snail> snails = this.getObjects(Snail.class);
        int xCoor = (int) snails.get(0).getExactX();

        if (xCoor >= 550)
        {
            isShown = true;
            String msg = "PLACE YOUR FINGERS TO THE \n" +
                "CORRESPONDING KEYS AND FOLLOW THE COLORS.\n" +
                "COME ON, GIVE IT A CHANCE! IT SHOULD\n" +
                "BE A LITTLE AWKWARD AT FIRST, BUT ONCE\n" +
                "YOU GET USED TO IT, YOU WILL LOVE IT!\n" +
                "PLUS YOU WILL LEARN TO TYPE SO QUICKLY! \n" +
                "AND YOU WILL HELP ME GET BACK HOME! \n" +
                "SO THANK YOU! ARE YOU READY TO BEGIN?";
            removeObject(firstBubble);
            Bubble secondBubble = new Bubble(50,new Vector(0,1),msg,new Font("Helvetica", Font.PLAIN, 18), 30); 
            addObject(secondBubble, 650, 620);
        }

    }

}
