import greenfoot.*;
import java.util.List;
import java.util.ArrayList;
import java.awt.Color;
import java.awt.Font;

/**
 * Class Computer represents the world that welcomes players in the game.
 * 
 * @author Maria - Despoina Gkaintatzi 
 * @version 24.04.2015
 */
public class Computer extends World
{
    /**
     * Constructor for objects of class Computer.
     * 
     */
    public Computer()
    {    
        super(1200, 800, 1); 
        prepare();
    }
    /**
     * Act method for Computer world.
     */
    public void act()
    {
        play();
    }
    
    /**
     * Adds objects snail and message to the world.
     */
    private void prepare()
    {
        addObject(new Snail(50,new Vector(0,1)), 460, 200);
        String message = "This is Mr. Fingers!\n Mr.Fingers is a snail, \nlost in the big city!\nHe is trying to get back \nto the woods where he comes from.\n" +
                         "His family and friends have no clue about \nwhere Mr Fingers is and are worried sick!\n Mr. Fingers has to send them an email \nto inform them about his situation.\n" +
                         "Oh, but what an irony! Mr. Fingers has no fingers!\n How is he supposed to write the email?\n" +
                         "Maybe you could give him a hand… \nType every letter you see and help \npoor Mr. Fingers go home as fast as he can.\n" +
                         "The more correct letters you type, \nthe faster Mr. Fingers move. \nWould you like to give it a try?\n\n" +
                         "Click to continue";
        Message introMessage = new Message(message, new Font("Consolas", Font.PLAIN, 20), Color.white);
        addObject(introMessage, 618, 340); 
        
    }
    
    /**
     * Changes world after clicking in the world.
     */
    private void play()
    {
        if(Greenfoot.mouseClicked(null))
        {
          Greenfoot.setWorld(new Desktop(new Snail(50,new Vector(0,1))));
        }
    }
}
