import greenfoot.*;
import java.awt.Color;
import java.awt.Font;
import java.util.List;
import java.util.ArrayList;

/**
 * Class City represents the world from which Snail is trying to escape. 
 * Players must type the letter they see on top of the screen.
 * The more they type correctly the faster Snail moves.
 * 
 * @author Maria - Despoina Gkaintatzi 
 * @version 12.06.2015
 */
public class City extends World 
{
    private Letter letter;
    private Counter scoreCounter;
    private Counter lifeCounter;
    private List<GreenfootImage> images;
    private Button buttonA;
    private Button buttonB;
    private Button buttonC;
    private Button buttonD;
    private Button buttonE;
    private Button buttonF;
    private Button buttonG;
    private Button buttonH;
    private Button buttonI;
    private Button buttonJ;
    private Button buttonK;
    private Button buttonL;
    private Button buttonM;
    private Button buttonN;
    private Button buttonO;
    private Button buttonP;
    private Button buttonQ;
    private Button buttonR;
    private Button buttonS;
    private Button buttonT;
    private Button buttonU;
    private Button buttonV;
    private Button buttonW;
    private Button buttonX;
    private Button buttonY;
    private Button buttonZ;
    private Button buttonSemiColon;
    private Button buttonFullStop;
    private Button buttonComma;
    private Button buttonQuestion;
    private Button button;

    /**
     * Constructor for objects of class City.
     * 
     */
    public City(Snail snail)
    {    
        super(1200, 800, 1); 
        prepare();
        addObject(snail, 50, 368); 
        images = new ArrayList(5);
        images.add(0,new GreenfootImage("city.png"));
        images.add(1,new GreenfootImage("village.png"));
        images.add(2,new GreenfootImage("desert.png"));
        images.add(3,new GreenfootImage("snowy.png"));
        images.add(4,new GreenfootImage("forest.png"));

        setBackground(images.get(0));
    } 

    /**
     * Act method for class City.
     */
    public void act()
    {
        checkLives();
        checkClick();
        changeCityImage();
        changeButtonColor();
    }

    /**
     * Returns the scoreCounter.
     * 
     * @return Counter scoreCounter
     */
    public Counter getScoreCounter()
    {
        return scoreCounter;
    }

    /**
     * Returns the lifeCounter.
     * 
     * @return Counter lifeCounter
     */
    public Counter getLifeCounter()
    {
        return lifeCounter;
    }

    /**
     * Makes background scroll
     */
    public void scrollBackground()
    {
        GreenfootImage background = new GreenfootImage(getBackground());
        getBackground().drawImage(background, -5, 0);
        getBackground().drawImage(background, getWidth()-11, 0);
    }

    /**
     * This method is called when the game is over to display the final score.
     * 
     * @param message(String) the message to be displayed when the game is over.
     */
    public void gameOver(String message) 
    {
        addObject(new ScoreBoard(message,scoreCounter.getValue()),getWidth()/2 , getHeight()/2);
    }

    /**
     * Finds the correct key according to the given letter.
     * 
     * @param letter(String) the letter of the key in question.
     */
    public Button whichButton(String letter)
    {
        if (letter.equalsIgnoreCase("a"))
        {
            button = buttonA;
        }
        else if (letter.equalsIgnoreCase("b"))
        {
            button = buttonB;
        }
        else if (letter.equalsIgnoreCase("c"))
        {
            button = buttonC;
        }
        else if (letter.equalsIgnoreCase("d"))
        {
            button = buttonD;
        }
        else if (letter.equalsIgnoreCase("e"))
        {
            button = buttonE;
        }
        else if (letter.equalsIgnoreCase("f"))
        {
            button = buttonF;
        }
        else if (letter.equalsIgnoreCase("g"))
        {
            button = buttonG;
        }
        else if (letter.equalsIgnoreCase("h"))
        {
            button = buttonH;
        }
        else if (letter.equalsIgnoreCase("i"))
        {
            button = buttonI;
        }
        else if (letter.equalsIgnoreCase("j"))
        {
            button = buttonJ;
        }
        else if (letter.equalsIgnoreCase("k"))
        {
            button = buttonK;
        }
        else if (letter.equalsIgnoreCase("l"))
        {
            button = buttonL;
        }
        else if (letter.equalsIgnoreCase("m"))
        {
            button = buttonM;
        }
        else if (letter.equalsIgnoreCase("n"))
        {
            button = buttonN;
        }
        else if (letter.equalsIgnoreCase("o"))
        {
            button = buttonO;
        }
        else if (letter.equalsIgnoreCase("p"))
        {
            button = buttonP;
        }
        else if (letter.equalsIgnoreCase("q"))
        {
            button = buttonQ;
        }
        else if (letter.equalsIgnoreCase("r"))
        {
            button = buttonR;
        }
        else if (letter.equalsIgnoreCase("s"))
        {
            button = buttonS;
        }
        else if (letter.equalsIgnoreCase("t"))
        {
            button = buttonT;
        }
        else if (letter.equalsIgnoreCase("u"))
        {
            button = buttonU;
        }
        else if (letter.equalsIgnoreCase("v"))
        {
            button = buttonV;
        }
        else if (letter.equalsIgnoreCase("w"))
        {
            button = buttonW;
        }
        else if (letter.equalsIgnoreCase("x"))
        {
            button = buttonX;
        }
        else if (letter.equalsIgnoreCase("y"))
        {
            button = buttonY;
        }
        else if (letter.equalsIgnoreCase("z"))
        {
            button = buttonZ;
        }
        else if (letter.equals("."))
        {
            button = buttonFullStop;
        }
        else if (letter.equals(","))
        {
            button = buttonComma;
        }
        else if (letter.equals(";"))
        {
            button = buttonSemiColon;
        }
        else if (letter.equals("?"))
        {
            button = buttonQuestion;
        }
        return button;
    }

    /** 
     * Resets the colour of the button after the correct key is typed.
     */
    public void resetButtonColor(String letter)
    {
        whichButton(letter).clearButton();
        whichButton(letter).drawSomeLetter(letter.toUpperCase(),Color.black);
    }

    /**
     * Initiates components that will be included in the constructor
     */
    private void prepare()
    {
        letter = new Letter(Color.yellow);
        scoreCounter = new Counter("Score: ", 0, 0);
        lifeCounter = new Counter("Lives: ", 5, 5);
        addObject(scoreCounter, 1100, 50);
        addObject(lifeCounter, 1100, 100);
        addObject(letter,600,100);
        buttonA = new Button("A");
        buttonB = new Button("B");
        buttonC = new Button("C");
        buttonD = new Button("D");
        buttonE = new Button("E");
        buttonF = new Button("F");
        buttonG = new Button("G");
        buttonH = new Button("H");
        buttonI = new Button("I");
        buttonJ = new Button("J");
        buttonK = new Button("K");
        buttonL = new Button("L");
        buttonM = new Button("M");
        buttonN = new Button("N");
        buttonO = new Button("O");
        buttonP = new Button("P");
        buttonQ = new Button("Q");
        buttonR = new Button("R");
        buttonS = new Button("S");
        buttonT = new Button("T");
        buttonU = new Button("U");
        buttonV = new Button("V");
        buttonW = new Button("W");
        buttonX = new Button("X");
        buttonY = new Button("Y");
        buttonZ = new Button("Z");
        buttonSemiColon = new Button(";");
        buttonFullStop = new Button(".");
        buttonComma = new Button(",");
        buttonQuestion = new Button("?");
        button = new Button("");

        addObject(buttonQ, 240, 440);
        addObject(buttonW, 310, 440);
        addObject(buttonE, 380, 440);
        addObject(buttonR, 450, 440);
        addObject(buttonT, 520, 440);
        addObject(buttonY, 590, 440);
        addObject(buttonU, 660, 440);
        addObject(buttonI, 730, 440);
        addObject(buttonO, 800, 440);
        addObject(buttonP, 870, 440);
        addObject(buttonA, 260, 520);
        addObject(buttonS, 330, 520);
        addObject(buttonD, 400, 520);
        addObject(buttonF, 470, 520);
        addObject(buttonG, 540, 520);
        addObject(buttonH, 610, 520);
        addObject(buttonJ, 680, 520);
        addObject(buttonK, 750, 520);
        addObject(buttonL, 820, 520);
        addObject(buttonSemiColon, 890, 520);
        addObject(buttonZ, 300, 600);
        addObject(buttonX, 370, 600);
        addObject(buttonC, 440, 600);
        addObject(buttonV, 510, 600);
        addObject(buttonB, 580, 600);
        addObject(buttonN, 650, 600);
        addObject(buttonM, 720, 600);
        addObject(buttonComma, 790, 600);
        addObject(buttonFullStop, 860, 600);
        addObject(buttonQuestion, 930, 600);

        GreenfootImage leftHand = new GreenfootImage("leftHand.png");
        GreenfootImage rightHand = new GreenfootImage("rightHand.png");
        leftHand.setTransparency(100);
        rightHand.setTransparency(100);

        addObject(new LeftHand(leftHand),400,710);
        addObject(new RightHand(rightHand),730,710);
    }

    /**
     * Checks if the player has used all the lifes he has and ends the game.
     */
    private void checkLives()
    {
        if (lifeCounter.getValue() == 0)
        {
            Greenfoot.playSound("fanfare.wav");
            gameOver("Game Over");
            Greenfoot.stop();
        }
    }  

    /**
     * Changes the colour of the button to be typed.
     */
    private void changeButtonColor()
    {
        List <Letter> letters = getObjects(Letter.class);
        Letter letter = letters.get(0);

        for (int i = 97; i <= 122; i++)
        {   
            if( letter.getTextImage().getText().equalsIgnoreCase("" + (char)i))
            {
                String theLetter = ("" + (char)i);
                if (theLetter.equalsIgnoreCase("j") || theLetter.equalsIgnoreCase("u") || 
                theLetter.equalsIgnoreCase("h") || theLetter.equalsIgnoreCase("y") || 
                theLetter.equalsIgnoreCase("n") || theLetter.equalsIgnoreCase("m"))
                {
                    whichButton(letter.getTextImage().getText()).clearButton();
                    whichButton(letter.getTextImage().getText()).drawSomeLetter("" + (char)(i-32), new Color(63,236,16));
                    addObject(new Arrow(), 700, 700);
                }
                else if (theLetter.equalsIgnoreCase("f") || theLetter.equalsIgnoreCase("g") ||
                theLetter.equalsIgnoreCase("t") || theLetter.equalsIgnoreCase("r") ||
                theLetter.equalsIgnoreCase("v") || theLetter.equalsIgnoreCase("b"))
                {
                    whichButton(letter.getTextImage().getText()).clearButton();
                    whichButton(letter.getTextImage().getText()).drawSomeLetter("" + (char)(i-32), new Color(63,236,16));
                    addObject(new Arrow(), 420, 700);
                }
                else if (theLetter.equalsIgnoreCase("k") || theLetter.equalsIgnoreCase("i"))
                {
                    whichButton(letter.getTextImage().getText()).clearButton();
                    whichButton(letter.getTextImage().getText()).drawSomeLetter("" + (char)(i-32), new Color(226,108,222));
                    addObject(new Arrow(), 750, 700);
                }
                else if (theLetter.equalsIgnoreCase("d") || theLetter.equalsIgnoreCase("e") || theLetter.equalsIgnoreCase("c"))
                {
                    whichButton(letter.getTextImage().getText()).clearButton();
                    whichButton(letter.getTextImage().getText()).drawSomeLetter("" + (char)(i-32), new Color(226,108,222));
                    addObject(new Arrow(), 370, 700);
                }
                else if (theLetter.equalsIgnoreCase("l") || theLetter.equalsIgnoreCase("o"))
                {
                    whichButton(letter.getTextImage().getText()).clearButton();
                    whichButton(letter.getTextImage().getText()).drawSomeLetter("" + (char)(i-32), new Color(73,188,221));
                    addObject(new Arrow(), 800, 700);
                }
                else if (theLetter.equalsIgnoreCase("s") || theLetter.equalsIgnoreCase("w") || theLetter.equalsIgnoreCase("x"))
                {
                    whichButton(letter.getTextImage().getText()).clearButton();
                    whichButton(letter.getTextImage().getText()).drawSomeLetter("" + (char)(i-32), new Color(73,188,221));
                    addObject(new Arrow(), 320, 700);
                }
                else if (theLetter.equalsIgnoreCase("p"))
                {
                    whichButton(letter.getTextImage().getText()).clearButton();
                    whichButton(letter.getTextImage().getText()).drawSomeLetter("" + (char)(i-32), new Color(240,113,10));
                    addObject(new Arrow(), 850, 700);
                }
                else if (theLetter.equalsIgnoreCase("a") || theLetter.equalsIgnoreCase("q") || theLetter.equalsIgnoreCase("z"))
                {
                    whichButton(letter.getTextImage().getText()).clearButton();
                    whichButton(letter.getTextImage().getText()).drawSomeLetter("" + (char)(i-32), new Color(240,113,10));
                    addObject(new Arrow(), 270, 700);
                }
            }
        }

        if (letter.getTextImage().getText().equals(","))
        {
            whichButton(letter.getTextImage().getText()).clearButton();
            whichButton(letter.getTextImage().getText()).drawSomeLetter(",", new Color(226,108,222));
            addObject(new Arrow(), 750, 700);
        }
        else if (letter.getTextImage().getText().equals("."))
        {
            whichButton(letter.getTextImage().getText()).clearButton();
            whichButton(letter.getTextImage().getText()).drawSomeLetter(".", new Color(73,188,221));
            addObject(new Arrow(), 800, 700);
        }
        else if (letter.getTextImage().getText().equals(";"))
        {
            whichButton(letter.getTextImage().getText()).clearButton();
            whichButton(letter.getTextImage().getText()).drawSomeLetter(";", new Color(240,113,10));
            addObject(new Arrow(), 850, 700);
        }
        else if (letter.getTextImage().getText().equals("?"))
        {
            whichButton(letter.getTextImage().getText()).clearButton();
            whichButton(letter.getTextImage().getText()).drawSomeLetter("?", new Color(240,113,10));
            addObject(new Arrow(), 850, 700);
        }

    }

    /**
     * Removes message if someone clicks in it.
     * 
     * @param actor(Actor) the actor to be removed.
     */
    private void checkClick()
    {
        List <MessageBoard> messages = getObjects(MessageBoard.class);
        if (!messages.isEmpty())
        {
            MessageBoard messageBoard = messages.get(0);
            if(Greenfoot.mouseClicked(messageBoard))
            {
                removeObject(messageBoard);
            }
        }
    }

    /**
     * Changes the background image according to the level, when passes to the next level
     */
    private void changeCityImage()
    {
        if (Snail.LEVEL == 2)
        {
            setBackground(images.get(1));
        }
        else if (Snail.LEVEL == 3)       {
            setBackground(images.get(2));
        }
        else if (Snail.LEVEL == 4)       {
            setBackground(images.get(3));
        }
        else if (Snail.LEVEL == 5)       {
            setBackground(images.get(4));
        }
    }
}
