import greenfoot.*;
import java.awt.Color;
import java.util.List;
import java.util.ArrayList;

/**
 * This class represents a Button object
 * 
 * @author Maria - Despoina Gkaintatzi 
 * @version 12.06.2015
 */
public class Button extends Actor
{
    private String letter;

    /**
     * Constructor for the objects of class Button.
     * 
     * @param letter(String) the letter of the button
     */
    public Button (String letter)
    {
        this.letter = letter;
        drawSomeLetter(letter, Color.black);
    }

    /**
     * Act - do whatever the Button wants to do. This method is called whenever
     * the 'Act' or 'Run' button gets pressed in the environment.
     */
    public void act() 
    {
        // Add your action code here.
    } 

    /**
     * Draws a given letter in a specific color in the image that represents the actor.
     * 
     * @param letter(String) the letter to be drawn in the balloon
     * @param color(Color) the color of the letter
     */
    public void drawSomeLetter(String letter,Color color)
    {
        int fontSize = 30;
        Color trans = new Color(0,0,0,0);
        GreenfootImage image = new GreenfootImage(letter, fontSize, color, trans); // creates letter image  
        int xOff = 80;   
        int yOff = 80; 
        getImage().drawImage(image, xOff/4, yOff/4);
    }

    /**
     * Clears the letter from the button.
     */
    public void clearButton()
    {
        GreenfootImage image = getImage();
        image.clear();
        setImage("button.png");
    }
}
