import greenfoot.*;
import java.awt.Font;
import java.awt.Color;

/**
 * This class creates a Bubble object
 * 
 * @author Maria - Despoina Gkaintatzi 
 * @version 12.06.2015
 */
public class Bubble extends SmoothMover
{
    private TextImage image; 
    private int size;
    
    /**
     * Constructor for the objects of class Bubble.
     * 
     * @param size(int) the desirable size
     */
    public Bubble(int size)
    {
        super(new Vector(270, 1));
        setSize(size);
    }

    /**
     * Constructor for the objects of class Bubble.
     * 
     * @param size(int) the desirable size
     * @param speed(Vector) the speed of the bubble
     * @param message(String) the message to be displayed
     * @param font(Font) the fonts of the message
     * @param x(int) the x coordinate where the bubble image will be drawn
     */
    public Bubble(int size, Vector speed, String message, Font font, int x)
    {
        super(speed);
        image = new TextImage(message,font, Color.white, null);
        GreenfootImage bubbleImage = getImage();
        bubbleImage.drawImage(image, x, x+100);
    }

    /**
     * Act - do whatever the Bubble wants to do. This method is called whenever
     * the 'Act' or 'Run' button gets pressed in the environment.
     */
    public void act() 
    {
        move();
        // Add your action code here.
    }    

    /**
     * Sets the size of this bubble.
     * 
     * @param size(int) the desirable size
     */
    public void setSize(int size) 
    {
        this.size = size;
        GreenfootImage image = getImage();
        image.scale(size, size);
    }
}
