import greenfoot.*;
import java.awt.Color;
import java.util.List;
import java.util.ArrayList;

/**
 * This class creates a Balloon object.
 * 
 * @author Maria - Despoina Gkaintatzi 
 * @version 24.04.2015
 */
public class Balloon extends SmoothMover
{
    private static final int NUM_FRAGMENTS = 40;
    private String letter;
    private int size;
    private Vector speed;
    private int hit = 0;
    long removeTime  = System.currentTimeMillis();

    /**
     * Constructor for objects of class Balloon.
     * 
     * @param size(int) the size of the balloon
     */
    public Balloon(int size)
    {
        super(new Vector(270, 1));
        setSize(size);
    }

    /**
     * Constructor for objects of class Balloon
     * 
     * @param size(int) the size of the balloon
     * @param speed(Vector) the speed of the balloon
     */
    public Balloon(int size, Vector speed, String letter)
    {
        super(speed);
        this.letter = letter;
        drawSomeLetter(letter, Color.black);
    }

    /**
     * Act - do whatever the Balloon wants to do. This method is called whenever
     * the 'Act' or 'Run' button gets pressed in the environment.
     */
    public void act() 
    {
        move();
        checkKeys();

    } 

    /**
     * Sets the size of this balloon.
     * 
     * @param size(int) the desirable size
     */
    public void setSize(int size) 
    {
        this.size = size;
        GreenfootImage image = getImage();
        image.scale(size, size);
    }

    /**
     * Makes a sound every time a key is pressed. The sound differs according to whether 
     * the key being pressed is the expected key.
     * 
     * @param correct(boolean) true if the key is correct
     */
    public void makeSound(boolean correct)
    {

        if (correct)
            Greenfoot.playSound("Yes.wav");
        else
            Greenfoot.playSound("Aww.wav");

    }

    /**
     * Breakes the balloon.
     */
    public void breakBalloon()
    {
        Greenfoot.playSound("Balloon Popping.wav");
        placePiece(getX(), getY(), NUM_FRAGMENTS);
        getWorld().removeObject(this);
    }

    /**
     * Draws a given letter in a specific color in the image that represents the actor.
     * 
     * @param letter(String) the letter to be drawn in the balloon
     * @param color(Color) the color of the letter
     */
    public void drawSomeLetter(String letter,Color color)
    {
        int fontSize = 40;
        Color trans = new Color(0,0,0,0);
        GreenfootImage image = new GreenfootImage(letter, fontSize, color, trans); // creates letter image  
        int xOff = 60;   
        int yOff = 80; 
        getImage().drawImage(image, xOff/2 + 12, yOff/2);
    }

    /**
     * Places pieces of the balloon after breaking.
     * 
     * @param x(int) x coordinate
     * @param y(int) y coordinate
     * @param numFragments(int) the number of pieces to place
     */
    private void placePiece(int x, int y, int numFragments)
    {
        for (int i=0; i < numFragments; i++) {
            getWorld().addObject ( new Piece(), x, y );
        }
    }

    /**
     * Checks whether the appropriate key is being pressed and acts accordingly.
     */
    private void checkKeys()
    {
        if (getWorld() instanceof Sky){
            List <Letter> letters = ((Sky)getWorld()).getObjects(Letter.class);
            Letter letter = new Letter(Color.white);

            if (letters.size() == 1)                    // finds the first Letter from the left, which is the Letter to be typed
            {
                letter = letters.get(0);
            }
            else
            {
                int minX = 1200;
                int pos = 0;
                for (int i = 0; i < letters.size(); i++)
                {
                    if (letters.get(i).getX() < minX)
                    {
                        minX = letters.get(i).getX();
                        pos = i;
                    }
                }

                letter = letters.get(pos);
            }

            String aLetter = letter.getTextImage().getText();
            TextImage image;

            if (Greenfoot.getKey() != null)
            {
                if (Greenfoot.isKeyDown(aLetter))
                {
                    makeSound(true);
                    ((Sky)getWorld()).getScoreCounter().add(10, 10000);
                    ((Sky)getWorld()).removeObject(letter);
                    breakBalloon();
                    hit++;
                    if (hit == 50)                               // accelerates the move of the balloon every fifty successive times that the right key was typed
                    {
                        hit = 0;
                        accelerate(2);
                    }
                }
                else 
                {
                    drawSomeLetter(aLetter, Color.red);
                    makeSound(false);
                    image = letter.getTextImage().colored(Color.red, null);
                    letter.setImage(image);
                    ((Sky)getWorld()).getLifeCounter().subtract(1, 0);
                    accelerate(0.5);                                      
                }
            }
        }
    }
}
